/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.chatlet;

import com.ibm.hwmca.fw.fcs.chatlet.ChatletErrorResponse;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletInitialRequest;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletMessage;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletPacket;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletProtocol;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletRequest;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletResponse;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletTerminateRequest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;

final class ChatletObjectFactory
implements ChatletProtocol {
    private static final String TRACE_MASKF = "XFCS-OFF";

    static ChatletPacket readResponse(ObjectInputStream in) throws IOException {
        if (in.readShort() != 1) {
            throw new RuntimeException("Protocol: Unknown protocol version noted in ChatletObjectFactory.readResponse()");
        }
        ChatletResponse packet = null;
        try {
            int chatletId = in.readInt();
            int transactionId = in.readInt();
            short type = in.readShort();
            short subType = in.readShort();
            Map properties = (Map)in.readObject();
            switch (type) {
                case 1: {
                    if (subType == 2) {
                        packet = new ChatletErrorResponse();
                        break;
                    }
                    packet = new ChatletResponse();
                    break;
                }
                case 2: {
                    packet = new ChatletMessage();
                    break;
                }
                default: {
                    throw new RuntimeException("Protocol: unexpected packet type noted in ChatletObjectFactory.readResponse()");
                }
            }
            packet.chatletId = chatletId;
            packet.requestType = type;
            packet.requestSubType = subType;
            packet.transactionId = transactionId;
            packet.properties = properties;
            packet.load(in);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("CNFException, missing java.util.Properties?");
        }
        return packet;
    }

    static ChatletPacket readRequest(ObjectInputStream in) throws IOException {
        if (in.readShort() != 1) {
            throw new RuntimeException("Protocol: Unknown protocol version noted in ChatletObjectFactory.readRequest()");
        }
        ChatletRequest packet = null;
        try {
            int chatletId = in.readInt();
            int transactionId = in.readInt();
            short type = in.readShort();
            short subType = in.readShort();
            Map properties = (Map)in.readObject();
            switch (type) {
                case 0: {
                    if (subType == 1) {
                        packet = new ChatletInitialRequest();
                        break;
                    }
                    if (subType == 3) {
                        packet = new ChatletTerminateRequest();
                        break;
                    }
                    packet = new ChatletRequest();
                    break;
                }
                default: {
                    throw new RuntimeException("Protocol: unexpected packet type noted in ChatletObjectFactory.readRequest()");
                }
            }
            packet.chatletId = chatletId;
            packet.requestType = type;
            packet.requestSubType = subType;
            packet.transactionId = transactionId;
            packet.properties = properties;
            packet.load(in);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("CNFException, missing java.util.Properties?");
        }
        return packet;
    }

    private ChatletObjectFactory() {
    }
}

